// Duke Nukem 3D v1.4+, Duke Nukem 64, and Duke Nukem: Total Meltdown CON Bytecode Decompiler
// CON Language and Bytecode Design by Todd Replogle
// Bytecode Modifications by Eurocom Entertainment Software and Aardvark Software
// Decompiler and Utility by Evan Ramos (Hendricks266), with Research Assistance from Fox Martins

// License: GNU GPLv2+
// See the Duke Nukem 3D Source Release for more information.

#include <cstdlib>
#include <cstdint>
#include <cstdio>
#include <cstring>

#include <vector>
#include <set>
#include <map>
#include <unordered_map>
#include <type_traits>


#if defined _LP64 || defined __LP64__ || defined __64BIT__ || _ADDR64 || defined _WIN64 || defined __arch64__ ||       \
__WORDSIZE == 64 || (defined __sparc && defined __sparcv9) || defined __x86_64 || defined __amd64 ||                   \
defined __x86_64__ || defined __amd64__ || defined _M_X64 || defined _M_IA64 || defined __ia64 || defined __IA64__

# define BITNESS64

#endif

#ifdef BITNESS64
#define size_t_u "llu"
#define size_t_X "llX"
#else
#define size_t_u "u"
#define size_t_X "lX"
#endif


#if defined _MSC_VER && _MSC_VER < 1800
# define inline __inline
#endif

#ifndef FORCE_INLINE
# ifdef _MSC_VER
#  define FORCE_INLINE __forceinline
# else
#  ifdef __GNUC__
#    define FORCE_INLINE inline __attribute__((always_inline))
#  else
#    define FORCE_INLINE inline
#  endif
# endif
#endif


#if defined _MSC_VER
# define ARRAY_COUNT(arr) _countof(arr)
#elif defined HAVE_CONSTEXPR
template <typename T, size_t N>
static FORCE_INLINE constexpr size_t ARRAY_COUNT(T const (&)[N]) noexcept
{
    return N;
}
#elif defined __cplusplus
struct bad_arg_to_ARRAY_COUNT
{
   class Is_pointer; // incomplete
   class Is_array {};
   template <typename T>
   static Is_pointer check_type(const T*, const T* const*);
   static Is_array check_type(const void*, const void*);
};
# define ARRAY_COUNT(arr) ( \
   0 * sizeof(reinterpret_cast<const ::bad_arg_to_ARRAY_COUNT*>(arr)) + \
   0 * sizeof(::bad_arg_to_ARRAY_COUNT::check_type((arr), &(arr))) + \
   sizeof(arr) / sizeof((arr)[0]) )
#else
# define ARRAY_COUNT(arr) (sizeof(arr) / sizeof((arr)[0]))
#endif


static FORCE_INLINE constexpr uint16_t B_SWAP16(uint16_t value)
{
    return
        ((value & 0xFF00u) >> 8u) |
        ((value & 0x00FFu) << 8u);
}
static FORCE_INLINE constexpr uint32_t B_SWAP32(uint32_t value)
{
    return
        ((value & 0xFF000000u) >> 24u) |
        ((value & 0x00FF0000u) >>  8u) |
        ((value & 0x0000FF00u) <<  8u) |
        ((value & 0x000000FFu) << 24u);
}
static FORCE_INLINE constexpr uint64_t B_SWAP64(uint64_t value)
{
    return
      ((value & 0xFF00000000000000ULL) >> 56ULL) |
      ((value & 0x00FF000000000000ULL) >> 40ULL) |
      ((value & 0x0000FF0000000000ULL) >> 24ULL) |
      ((value & 0x000000FF00000000ULL) >>  8ULL) |
      ((value & 0x00000000FF000000ULL) <<  8ULL) |
      ((value & 0x0000000000FF0000ULL) << 24ULL) |
      ((value & 0x000000000000FF00ULL) << 40ULL) |
      ((value & 0x00000000000000FFULL) << 56ULL);
}

template <size_t siz>
struct SwapFuncs
{
};
template <>
struct SwapFuncs<sizeof(uint16_t)>
{
    static auto constexpr const Swap = B_SWAP16;
};
template <>
struct SwapFuncs<sizeof(uint32_t)>
{
    static auto constexpr const Swap = B_SWAP32;
};
template <>
struct SwapFuncs<sizeof(uint64_t)>
{
    static auto constexpr const Swap = B_SWAP64;
};


#define MAXTILES 6144

static char const keyw[][32] =
{
    "definelevelname",  // 0
    "actor",            // 1    [#]
    "addammo",   // 2    [#]
    "ifrnd",            // 3    [C]
    "enda",             // 4    [:]
    "ifcansee",         // 5    [C]
    "ifhitweapon",      // 6    [#]
    "action",           // 7    [#]
    "ifpdistl",         // 8    [#]
    "ifpdistg",         // 9    [#]
    "else",             // 10   [#]
    "strength",         // 11   [#]
    "break",            // 12   [#]
    "shoot",            // 13   [#]
    "palfrom",          // 14   [#]
    "sound",            // 15   [filename.voc]
    "fall",             // 16   []
    "state",            // 17
    "ends",             // 18
    "define",           // 19
    "//",               // 20
    "ifai",             // 21
    "killit",           // 22
    "addweapon",        // 23
    "ai",               // 24
    "addphealth",       // 25
    "ifdead",           // 26
    "ifsquished",       // 27
    "sizeto",           // 28
    "{",                // 29
    "}",                // 30
    "spawn",            // 31
    "move",             // 32
    "ifwasweapon",      // 33
    "ifaction",         // 34
    "ifactioncount",    // 35
    "resetactioncount", // 36
    "debris",           // 37
    "pstomp",           // 38
    "/*",               // 39
    "cstat",            // 40
    "ifmove",           // 41
    "resetplayer",      // 42
    "ifonwater",        // 43
    "ifinwater",        // 44
    "ifcanshoottarget", // 45
    "ifcount",          // 46
    "resetcount",       // 47
    "addinventory",     // 48
    "ifactornotstayput",// 49
    "hitradius",        // 50
    "ifp",              // 51
    "count",            // 52
    "ifactor",          // 53
    "music",            // 54
    "include",          // 55
    "ifstrength",       // 56
    "definesound",      // 57
    "guts",             // 58
    "ifspawnedby",      // 59
    "gamestartup",      // 60
    "wackplayer",       // 61
    "ifgapzl",          // 62
    "ifhitspace",       // 63
    "ifoutside",        // 64
    "ifmultiplayer",    // 65
    "operate",          // 66
    "ifinspace",        // 67
    "debug",            // 68
    "endofgame",        // 69
    "ifbulletnear",     // 70
    "ifrespawn",        // 71
    "iffloordistl",     // 72
    "ifceilingdistl",   // 73
    "spritepal",        // 74
    "ifpinventory",     // 75
    "betaname",         // 76
    "cactor",           // 77
    "ifphealthl",       // 78
    "definequote",      // 79
    "quote",            // 80
    "ifinouterspace",   // 81
    "ifnotmoving",      // 82
    "respawnhitag",        // 83
    "tip",             // 84
    "ifspritepal",      // 85
    "money",         // 86
    "soundonce",         // 87
    "addkills",         // 88
    "stopsound",        // 89
    "ifawayfromwall",       // 90
    "ifcanseetarget",   // 91
    "globalsound",  // 92
    "lotsofglass", // 93
    "ifgotweaponce", // 94
    "getlastpal", // 95
    "pkick",  // 96
    "mikesnd", // 97
    "useractor",  // 98
    "sizeat",  // 99
    "addstrength", // 100   [#]
    "cstator", // 101
    "mail", // 102
    "paper", // 103
    "tossweapon", // 104
    "sleeptime", // 105
    "nullop", // 106
    "definevolumename", // 107
    "defineskillname", // 108
    "ifnosounds", // 109
    "clipdist", // 110
    "ifangdiffl" // 111
};

enum con_tokens
{
    CON_DEFINELEVELNAME = 0,  // 0
    CON_ACTOR,            // 1    [#]
    CON_ADDAMMO,   // 2    [#]
    CON_IFRND,            // 3    [C]
    CON_ENDA,             // 4    [:]
    CON_IFCANSEE,         // 5    [C]
    CON_IFHITWEAPON,      // 6    [#]
    CON_ACTION,           // 7    [#]
    CON_IFPDISTL,         // 8    [#]
    CON_IFPDISTG,         // 9    [#]
    CON_ELSE,             // 10   [#]
    CON_STRENGTH,         // 11   [#]
    CON_BREAK,            // 12   [#]
    CON_SHOOT,            // 13   [#]
    CON_PALFROM,          // 14   [#]
    CON_SOUND,            // 15   [FILENAME.VOC]
    CON_FALL,             // 16   []
    CON_STATE,            // 17
    CON_ENDS,             // 18
    CON_DEFINE,           // 19
    CON_LINECOMMENT,               // 20
    CON_IFAI,             // 21
    CON_KILLIT,           // 22
    CON_ADDWEAPON,        // 23
    CON_AI,               // 24
    CON_ADDPHEALTH,       // 25
    CON_IFDEAD,           // 26
    CON_IFSQUISHED,       // 27
    CON_SIZETO,           // 28
    CON_LEFTBRACE,                // 29
    CON_RIGHTBRACE,                // 30
    CON_SPAWN,            // 31
    CON_MOVE,             // 32
    CON_IFWASWEAPON,      // 33
    CON_IFACTION,         // 34
    CON_IFACTIONCOUNT,    // 35
    CON_RESETACTIONCOUNT, // 36
    CON_DEBRIS,           // 37
    CON_PSTOMP,           // 38
    CON_BLOCKCOMMENT,               // 39
    CON_CSTAT,            // 40
    CON_IFMOVE,           // 41
    CON_RESETPLAYER,      // 42
    CON_IFONWATER,        // 43
    CON_IFINWATER,        // 44
    CON_IFCANSHOOTTARGET, // 45
    CON_IFCOUNT,          // 46
    CON_RESETCOUNT,       // 47
    CON_ADDINVENTORY,     // 48
    CON_IFACTORNOTSTAYPUT,// 49
    CON_HITRADIUS,        // 50
    CON_IFP,              // 51
    CON_COUNT,            // 52
    CON_IFACTOR,          // 53
    CON_MUSIC,            // 54
    CON_INCLUDE,          // 55
    CON_IFSTRENGTH,       // 56
    CON_DEFINESOUND,      // 57
    CON_GUTS,             // 58
    CON_IFSPAWNEDBY,      // 59
    CON_GAMESTARTUP,      // 60
    CON_WACKPLAYER,       // 61
    CON_IFGAPZL,          // 62
    CON_IFHITSPACE,       // 63
    CON_IFOUTSIDE,        // 64
    CON_IFMULTIPLAYER,    // 65
    CON_OPERATE,          // 66
    CON_IFINSPACE,        // 67
    CON_DEBUG,            // 68
    CON_ENDOFGAME,        // 69
    CON_IFBULLETNEAR,     // 70
    CON_IFRESPAWN,        // 71
    CON_IFFLOORDISTL,     // 72
    CON_IFCEILINGDISTL,   // 73
    CON_SPRITEPAL,        // 74
    CON_IFPINVENTORY,     // 75
    CON_BETANAME,         // 76
    CON_CACTOR,           // 77
    CON_IFPHEALTHL,       // 78
    CON_DEFINEQUOTE,      // 79
    CON_QUOTE,            // 80
    CON_IFINOUTERSPACE,   // 81
    CON_IFNOTMOVING,      // 82
    CON_RESPAWNHITAG,        // 83
    CON_TIP,             // 84
    CON_IFSPRITEPAL,      // 85
    CON_MONEY,         // 86
    CON_SOUNDONCE,         // 87
    CON_ADDKILLS,         // 88
    CON_STOPSOUND,        // 89
    CON_IFAWAYFROMWALL,       // 90
    CON_IFCANSEETARGET,   // 91
    CON_GLOBALSOUND,  // 92
    CON_LOTSOFGLASS, // 93
    CON_IFGOTWEAPONCE, // 94
    CON_GETLASTPAL, // 95
    CON_PKICK,  // 96
    CON_MIKESND, // 97
    CON_USERACTOR,  // 98
    CON_SIZEAT,  // 99
    CON_ADDSTRENGTH, // 100   [#]
    CON_CSTATOR, // 101
    CON_MAIL, // 102
    CON_PAPER, // 103
    CON_TOSSWEAPON, // 104
    CON_SLEEPTIME, // 105
    CON_NULLOP, // 106
    CON_DEFINEVOLUMENAME, // 107
    CON_DEFINESKILLNAME, // 108
    CON_IFNOSOUNDS, // 109
    CON_CLIPDIST, // 110
    CON_IFANGDIFFL, // 111
};

enum conparamcategory_t
{
    CP_VALUE = 0,
    CP_ACTION,
    CP_MOVE,
    CP_AI,
    CP_MOVEFLAG,
    CP_TILENUM,
    CP_SOUND,
    CP_INVENTORY,
    CP_WEAPON,
    CP_PLAYERSTATUS,
    CP_STRENGTH,
    CP_STATE,
    CP_ACTORTYPE,
};

enum conflags_t
{
    CONFLAG_IF = 1<<0,
    CONFLAG_32BIT = 1<<1,
    CONFLAG_BLOCKLEVEL = 1<<2,
    CONFLAG_TOPLEVEL = 1<<3,
    CONFLAG_WTF = 1<<4,
    CONFLAG_UNSIGNED = 1<<5,
    CONFLAG_OPTIONALAFTERFIRST = 1<<6,
};

struct concommand_t
{
    uint8_t numblocklevelbytecodeparams;
    uint8_t conceptualparamcategory;
    uint8_t flags;
};

static concommand_t cmds[] =
{
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_DEFINELEVELNAME:  // 0
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_ACTOR:            // 1    [#]
    { 2, 0, CONFLAG_BLOCKLEVEL, }, // CON_ADDAMMO:   // 2    [#]
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFRND:            // 3    [C]
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_ENDA:             // 4    [:]
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFCANSEE:         // 5    [C]
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFHITWEAPON:      // 6    [#]
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_TOPLEVEL, }, // CON_ACTION:           // 7    [#]
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFPDISTL:         // 8    [#]
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFPDISTG:         // 9    [#]
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_ELSE:             // 10   [#]
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_STRENGTH:         // 11   [#]
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_BREAK:            // 12   [#]
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_SHOOT:            // 13   [#]
    { 4, 0, CONFLAG_BLOCKLEVEL, }, // CON_PALFROM:          // 14   [#]
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_SOUND:            // 15   [FILENAME.VOC]
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_FALL:             // 16   []
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_TOPLEVEL, }, // CON_STATE:            // 17
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_ENDS:             // 18
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_DEFINE:           // 19
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_TOPLEVEL|CONFLAG_WTF, }, // CON_LINECOMMENT:               // 20
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFAI:             // 21
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_KILLIT:           // 22
    { 2, 0, CONFLAG_BLOCKLEVEL, }, // CON_ADDWEAPON:        // 23
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_TOPLEVEL, }, // CON_AI:               // 24
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_ADDPHEALTH:       // 25
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFDEAD:           // 26
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFSQUISHED:       // 27
    { 2, 0, CONFLAG_BLOCKLEVEL, }, // CON_SIZETO:           // 28
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_LEFTBRACE:                // 29
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_RIGHTBRACE:                // 30
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_SPAWN:            // 31
    { 2, 0, CONFLAG_BLOCKLEVEL|CONFLAG_TOPLEVEL|CONFLAG_OPTIONALAFTERFIRST, }, // CON_MOVE:             // 32
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFWASWEAPON:      // 33
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFACTION:         // 34
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFACTIONCOUNT:    // 35
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_RESETACTIONCOUNT: // 36
    { 2, 0, CONFLAG_BLOCKLEVEL, }, // CON_DEBRIS:           // 37
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_PSTOMP:           // 38
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_TOPLEVEL|CONFLAG_WTF, }, // CON_BLOCKCOMMENT:               // 39
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_UNSIGNED, }, // CON_CSTAT:            // 40
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFMOVE:           // 41
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_RESETPLAYER:      // 42
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFONWATER:        // 43
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFINWATER:        // 44
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFCANSHOOTTARGET: // 45
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFCOUNT:          // 46
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_RESETCOUNT:       // 47
    { 2, 0, CONFLAG_BLOCKLEVEL, }, // CON_ADDINVENTORY:     // 48
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFACTORNOTSTAYPUT:// 49
    { 5, 0, CONFLAG_BLOCKLEVEL, }, // CON_HITRADIUS:        // 50
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF|CONFLAG_32BIT, }, // CON_IFP:              // 51
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_COUNT:            // 52
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFACTOR:          // 53
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_MUSIC:            // 54
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_INCLUDE:          // 55
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFSTRENGTH:       // 56
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_DEFINESOUND:      // 57
    { 2, 0, CONFLAG_BLOCKLEVEL, }, // CON_GUTS:             // 58
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFSPAWNEDBY:      // 59
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_GAMESTARTUP:      // 60
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_WACKPLAYER:       // 61
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFGAPZL:          // 62
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFHITSPACE:       // 63
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFOUTSIDE:        // 64
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFMULTIPLAYER:    // 65
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_OPERATE:          // 66
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFINSPACE:        // 67
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_DEBUG:            // 68
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_ENDOFGAME:        // 69
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFBULLETNEAR:     // 70
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFRESPAWN:        // 71
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFFLOORDISTL:     // 72
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFCEILINGDISTL:   // 73
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_SPRITEPAL:        // 74
    { 2, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFPINVENTORY:     // 75
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_BETANAME:         // 76
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_CACTOR:           // 77
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFPHEALTHL:       // 78
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_DEFINEQUOTE:      // 79
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_QUOTE:            // 80
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFINOUTERSPACE:   // 81
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFNOTMOVING:      // 82
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_RESPAWNHITAG:        // 83
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_TIP:             // 84
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFSPRITEPAL:      // 85
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_MONEY:         // 86
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_SOUNDONCE:         // 87
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_ADDKILLS:         // 88
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_STOPSOUND:        // 89
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFAWAYFROMWALL:       // 90
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFCANSEETARGET:   // 91
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_GLOBALSOUND:  // 92
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_LOTSOFGLASS: // 93
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFGOTWEAPONCE: // 94
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_GETLASTPAL: // 95
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_PKICK:  // 96
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_MIKESND: // 97
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_USERACTOR:  // 98
    { 2, 0, CONFLAG_BLOCKLEVEL, }, // CON_SIZEAT:  // 99
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_ADDSTRENGTH: // 100   [#]
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_CSTATOR: // 101
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_MAIL: // 102
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_PAPER: // 103
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_TOSSWEAPON: // 104
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_SLEEPTIME: // 105
    { 0, 0, CONFLAG_BLOCKLEVEL, }, // CON_NULLOP: // 106
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_DEFINEVOLUMENAME: // 107
    { 0, 0, CONFLAG_TOPLEVEL, }, // CON_DEFINESKILLNAME: // 108
    { 0, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFNOSOUNDS: // 109
    { 1, 0, CONFLAG_BLOCKLEVEL, }, // CON_CLIPDIST: // 110
    { 1, 0, CONFLAG_BLOCKLEVEL|CONFLAG_IF, }, // CON_IFANGDIFFL: // 111
};

/*
{
    case CON_DEFINELEVELNAME:  // 0
    case CON_ACTOR:            // 1    [#]
    case CON_ADDAMMO:   // 2    [#]
    case CON_IFRND:            // 3    [C]
    case CON_ENDA:             // 4    [:]
    case CON_IFCANSEE:         // 5    [C]
    case CON_IFHITWEAPON:      // 6    [#]
    case CON_ACTION:           // 7    [#]
    case CON_IFPDISTL:         // 8    [#]
    case CON_IFPDISTG:         // 9    [#]
    case CON_ELSE:             // 10   [#]
    case CON_STRENGTH:         // 11   [#]
    case CON_BREAK:            // 12   [#]
    case CON_SHOOT:            // 13   [#]
    case CON_PALFROM:          // 14   [#]
    case CON_SOUND:            // 15   [FILENAME.VOC]
    case CON_FALL:             // 16   []
    case CON_STATE:            // 17
    case CON_ENDS:             // 18
    case CON_DEFINE:           // 19
    case CON_LINECOMMENT:               // 20
    case CON_IFAI:             // 21
    case CON_KILLIT:           // 22
    case CON_ADDWEAPON:        // 23
    case CON_AI:               // 24
    case CON_ADDPHEALTH:       // 25
    case CON_IFDEAD:           // 26
    case CON_IFSQUISHED:       // 27
    case CON_SIZETO:           // 28
    case CON_LEFTBRACE:                // 29
    case CON_RIGHTBRACE:                // 30
    case CON_SPAWN:            // 31
    case CON_MOVE:             // 32
    case CON_IFWASWEAPON:      // 33
    case CON_IFACTION:         // 34
    case CON_IFACTIONCOUNT:    // 35
    case CON_RESETACTIONCOUNT: // 36
    case CON_DEBRIS:           // 37
    case CON_PSTOMP:           // 38
    case CON_BLOCKCOMMENT:               // 39
    case CON_CSTAT:            // 40
    case CON_IFMOVE:           // 41
    case CON_RESETPLAYER:      // 42
    case CON_IFONWATER:        // 43
    case CON_IFINWATER:        // 44
    case CON_IFCANSHOOTTARGET: // 45
    case CON_IFCOUNT:          // 46
    case CON_RESETCOUNT:       // 47
    case CON_ADDINVENTORY:     // 48
    case CON_IFACTORNOTSTAYPUT:// 49
    case CON_HITRADIUS:        // 50
    case CON_IFP:              // 51
    case CON_COUNT:            // 52
    case CON_IFACTOR:          // 53
    case CON_MUSIC:            // 54
    case CON_INCLUDE:          // 55
    case CON_IFSTRENGTH:       // 56
    case CON_DEFINESOUND:      // 57
    case CON_GUTS:             // 58
    case CON_IFSPAWNEDBY:      // 59
    case CON_GAMESTARTUP:      // 60
    case CON_WACKPLAYER:       // 61
    case CON_IFGAPZL:          // 62
    case CON_IFHITSPACE:       // 63
    case CON_IFOUTSIDE:        // 64
    case CON_IFMULTIPLAYER:    // 65
    case CON_OPERATE:          // 66
    case CON_IFINSPACE:        // 67
    case CON_DEBUG:            // 68
    case CON_ENDOFGAME:        // 69
    case CON_IFBULLETNEAR:     // 70
    case CON_IFRESPAWN:        // 71
    case CON_IFFLOORDISTL:     // 72
    case CON_IFCEILINGDISTL:   // 73
    case CON_SPRITEPAL:        // 74
    case CON_IFPINVENTORY:     // 75
    case CON_BETANAME:         // 76
    case CON_CACTOR:           // 77
    case CON_IFPHEALTHL:       // 78
    case CON_DEFINEQUOTE:      // 79
    case CON_QUOTE:            // 80
    case CON_IFINOUTERSPACE:   // 81
    case CON_IFNOTMOVING:      // 82
    case CON_RESPAWNHITAG:        // 83
    case CON_TIP:             // 84
    case CON_IFSPRITEPAL:      // 85
    case CON_MONEY:         // 86
    case CON_SOUNDONCE:         // 87
    case CON_ADDKILLS:         // 88
    case CON_STOPSOUND:        // 89
    case CON_IFAWAYFROMWALL:       // 90
    case CON_IFCANSEETARGET:   // 91
    case CON_GLOBALSOUND:  // 92
    case CON_LOTSOFGLASS: // 93
    case CON_IFGOTWEAPONCE: // 94
    case CON_GETLASTPAL: // 95
    case CON_PKICK:  // 96
    case CON_MIKESND: // 97
    case CON_USERACTOR:  // 98
    case CON_SIZEAT:  // 99
    case CON_ADDSTRENGTH: // 100   [#]
    case CON_CSTATOR: // 101
    case CON_MAIL: // 102
    case CON_PAPER: // 103
    case CON_TOSSWEAPON: // 104
    case CON_SLEEPTIME: // 105
    case CON_NULLOP: // 106
    case CON_DEFINEVOLUMENAME: // 107
    case CON_DEFINESKILLNAME: // 108
    case CON_IFNOSOUNDS: // 109
    case CON_CLIPDIST: // 110
    case CON_IFANGDIFFL: // 111
}
*/









static size_t constexpr const numactorparams = 4;
static size_t constexpr const numactionparams = 5;
static size_t constexpr const nummoveparams = 2;
static size_t constexpr const numaiparams = 3;




typedef long int filepos_t;

static constexpr const char indentation[] = "  ";
static constexpr const char newline[] = "\r\n";




template <typename bytecode_t, typename actorscrptr_t>
struct decompiler
{
    using ubytecode_t = typename std::make_unsigned<bytecode_t>::type;

    int32_t gamestartup[30];
    bytecode_t script[21500]; // 21484
    actorscrptr_t actorscrptr[MAXTILES];
    uint8_t actortype[MAXTILES];


    std::map<actorscrptr_t, bytecode_t> actors;
    std::set<bytecode_t> states, actions, moves, ais;

    std::unordered_map<bytecode_t, bytecode_t> seq_actors, seq_states, seq_actions, seq_moves, seq_ais;
    // std::map<bytecode_t, uint8_t> blockstarts;
    std::vector<uint8_t> blocktypes;


    uint8_t knownused[ARRAY_COUNT(script)];
    uint8_t checkanyused(size_t start, size_t count) const
    {
        uint8_t flag = 0;
        for (size_t z = 0; z < count; ++z)
            flag |= knownused[start + z];
        return flag;
    }
    uint8_t checkallused(size_t start, size_t count) const
    {
        uint8_t flag = 1;
        for (size_t z = 0; z < count; ++z)
            flag &= knownused[start + z];
        return flag;
    }
    void markused(size_t start, size_t count)
    {
        memset(knownused + start, 1, count);
    }
    void markusedunsure(size_t start, size_t count)
    {
        if (checkanyused(start, count))
            fprintf(stderr, "warning: overlapping block at bytecode id %" size_t_u " for %" size_t_u "\n", start, count);

        markused(start, count);
    }
    bool maybeaddaction(bytecode_t x)
    {
        static constexpr size_t const numparams = numactionparams;

        if ((ubytecode_t)x <= 0 || (ubytecode_t)x >= ARRAY_COUNT(script))
            return false;

        if (actions.count(x))
            return false;

        uint8_t const anyused = checkanyused(x, numparams);

        if (anyused || ais.count(x) || moves.count(x) || states.count(x) || actors.find(x) != actors.end())
        {
            fprintf(stderr, "warning: overlapping action claimed to be at bytecode id %d\n", x);
            return false;
        }

        actions.insert(x);
        markused(x, numparams);
        return true;
    }
    bool maybeaddmove(bytecode_t x)
    {
        static constexpr size_t const numparams = nummoveparams;

        if ((ubytecode_t)x <= 1 || (ubytecode_t)x >= ARRAY_COUNT(script))
            return false;

        if (moves.count(x))
            return false;

        uint8_t const anyused = checkanyused(x, numparams);

        if (anyused || ais.count(x) || actions.count(x) || states.count(x) || actors.find(x) != actors.end())
        {
            fprintf(stderr, "warning: overlapping move claimed to be at bytecode id %d\n", x);
            return false;
        }

        moves.insert(x);
        markused(x, numparams);
        return true;
    }
    bool maybeaddai(bytecode_t x)
    {
        static constexpr size_t const numparams = numaiparams;

        if ((ubytecode_t)x <= 0 || (ubytecode_t)x >= ARRAY_COUNT(script))
            return false;

        if (ais.count(x))
            return false;

        uint8_t const anyused = checkanyused(x, numparams);

        if (anyused || actions.count(x) || moves.count(x) || states.count(x) || actors.find(x) != actors.end())
        {
            fprintf(stderr, "warning: overlapping ai claimed to be at bytecode id %d\n", x);
            return false;
        }

        ais.insert(x);
        markused(x, numparams);
        return true;
    }
    bool maybeaddstate(bytecode_t x)
    {
        if (states.count(x))
            return false;

        states.insert(x);
        fprintf(stdout, "call tree of state bytecode id %d\n", x);
        prepareblock(script + x, x, CON_ENDS);
        return true;
    }

    // just for internal verification
    void complainifused(size_t start, size_t count)
    {
        if (checkanyused(start, count))
            fprintf(stderr, "warning: block not marked completely unused at bytecode id %" size_t_u " for %" size_t_u "\n", start, count);
    }
    void complainifunused(size_t start, size_t count)
    {
        if (!checkallused(start, count))
            fprintf(stderr, "warning: block not marked completely used at bytecode id %" size_t_u " for %" size_t_u "\n", start, count);
    }

    size_t calcnonzeroparams(bytecode_t const * code, size_t maxparams)
    {
        if (raw)
            return maxparams;

        size_t p;
        for (p = maxparams - 1; !code[p] && p < maxparams; --p) { }

        return p + (size_t)1;
    }

    void errorpos(char const * str, bytecode_t const * block, bytecode_t id, bytecode_t terminator)
    {
        ptrdiff_t const blockindex = block - script;
        size_t const blockoffset = blockindex * sizeof(script[0]);

        fprintf(stderr, "error: %s %d for %s bytecode id %d at %" size_t_u " 0x%" size_t_X "\n", str, *block, terminator == CON_ENDS ? keyw[CON_STATE] : keyw[CON_ACTOR], id, blockindex, script_offset + blockoffset);

        exit(666);
    }

    template<typename T>
    T defangOffset(T x)
    {
        return x >= offset_offset ? (x - offset_offset)/offset_width : x;
    }

    void prepareblock(bytecode_t const * block, bytecode_t id, bytecode_t terminator)
    {
        while (*block != terminator)
        {
            ubytecode_t const commandindex = *block;
            ptrdiff_t const blockindex = block - script;

            if (commandindex >= ARRAY_COUNT(cmds))
            {
                errorpos("out of range command", block, id, terminator);
            }

            auto const & command = cmds[commandindex];
            auto const flags = command.flags;
            auto params = command.numblocklevelbytecodeparams;

            if (flags & CONFLAG_WTF || !(flags & CONFLAG_BLOCKLEVEL))
            {
                errorpos("non-blocklevel command", block, id, terminator);
            }

            if (commandindex == CON_ENDA || commandindex == CON_ENDS)
            {
                errorpos("improper terminator", block, id, terminator);
            }

            if (flags & CONFLAG_32BIT && sizeof(bytecode_t) != sizeof(int32_t))
                params *= sizeof(int32_t)/sizeof(bytecode_t);
            if (flags & CONFLAG_IF)
                ++params;

            markusedunsure(blockindex, 1 + params);

            ++block;

            auto const param1 = defangOffset(*block);

            switch (commandindex)
            {
                case CON_STATE:
                    maybeaddstate(param1);
                    break;
                case CON_IFACTION:
                case CON_ACTION:
                    maybeaddaction(param1);
                    break;
                case CON_IFMOVE:
                case CON_MOVE:
                    maybeaddmove(param1);
                    break;
                case CON_IFAI:
                case CON_AI:
                    maybeaddai(param1);
                    if (param1)
                    {
                        bytecode_t const * const ai = script + param1;

                        bytecode_t aiparams[] = { defangOffset(ai[0]), defangOffset(ai[1]) };

                        if (aiparams[0])
                            maybeaddaction(aiparams[0]);

                        if (aiparams[1])
                            maybeaddmove(aiparams[1]);
                    }
                    break;
            }

            block += params;
        }

        ptrdiff_t const blockindex = block - script;
        markusedunsure(blockindex, 1);
    }


    void printi(bytecode_t x)
    {
        fprintf(outfp, " %d", x);
    }
    void printu(ubytecode_t x)
    {
        fprintf(outfp, " %u", x);
    }
    void printi32(int32_t x)
    {
        fprintf(outfp, " %d", x);
    }
    void printcommentu(ubytecode_t x)
    {
        fprintf(outfp, " // %u", x);
    }
    void printmoveflags(bytecode_t x)
    {
        return printu(x);
    }
    void printactor(bytecode_t x)
    {
        if (!x)
            return printi(x);

        if (anonymous)
            fprintf(outfp, " actor_");
        else
            fprintf(outfp, " actor_%d", seq ? seq_actors[x] : x);
    }
    void printaction(bytecode_t x)
    {
        if (!x)
            return printi(x);

        if (!actions.count(x))
        {
            fprintf(stderr, "warning: no such action %d\n", x);
            return printu(x);
        }

        if (anonymous)
            fprintf(outfp, " action_");
        else
            fprintf(outfp, " action_%d", seq ? seq_actions[x] : x);
    }
    void printmove(bytecode_t x)
    {
        if ((ubytecode_t)x <= 1)
            return printi(x);

        if (!moves.count(x))
        {
            fprintf(stderr, "warning: no such move %d, interpreting as moveflags\n", x);
            return printmoveflags(x);
        }

        if (anonymous)
            fprintf(outfp, " move_");
        else
            fprintf(outfp, " move_%d", seq ? seq_moves[x] : x);
    }
    void printai(bytecode_t x)
    {
        if (!x)
            return printi(x);

        if (!ais.count(x))
        {
            fprintf(stderr, "warning: no such ai %d\n", x);
            return printu(x);
        }

        if (anonymous)
            fprintf(outfp, " ai_");
        else
            fprintf(outfp, " ai_%d", seq ? seq_ais[x] : x);
    }
    void printstate(bytecode_t x)
    {
        if (!x)
            return printi(x);

        if (!states.count(x))
        {
            fprintf(stderr, "warning: no such state %d\n", x);
            return printu(x);
        }

        if (anonymous)
            fprintf(outfp, " state_");
        else
            fprintf(outfp, " state_%d", seq ? seq_states[x] : x);
    }
    void printtilenum(bytecode_t x)
    {
        return printi(x);
    }
    void printstrength(bytecode_t x)
    {
        return printi(x);
    }
#if 0
    void printweapon(bytecode_t x)
    {
        return printi(x);
    }
    void printinventory(bytecode_t x)
    {
        return printi(x);
    }
    void printplayerstatus(int32_t x)
    {
        return printi(x);
    }
    void printsound(bytecode_t x)
    {
        return printi(x);
    }
#endif
    void printcommand(bytecode_t x)
    {
        fprintf(outfp, "%d", x);
        if ((ubytecode_t)x < ARRAY_COUNT(keyw))
            fprintf(outfp, " / %s", keyw[x]);
    }



    filepos_t script_offset, actorscrptr_offset, actortype_offset;
    size_t script_count;

    void decompileblock(bytecode_t const * & block, bytecode_t id, bytecode_t terminator, size_t indent = 1)
    {
        size_t numifs = 0;

        while (*block != terminator)
        {
            ubytecode_t const commandindex = *block;

            if (commandindex >= ARRAY_COUNT(cmds))
            {
                errorpos("out of range command", block, id, terminator);
            }

            auto const & command = cmds[commandindex];
            auto const flags = command.flags;
            auto params = command.numblocklevelbytecodeparams;

            if (flags & CONFLAG_WTF || !(flags & CONFLAG_BLOCKLEVEL))
            {
                errorpos("non-blocklevel command", block, id, terminator);
            }

            if (commandindex == CON_ENDA || commandindex == CON_ENDS || commandindex == CON_RIGHTBRACE)
            {
                errorpos("improper terminator", block, id, terminator);
            }

            size_t realnumifs = numifs;
            if (commandindex == CON_LEFTBRACE || commandindex == CON_ELSE)
            {
                if (numifs > 0)
                    --realnumifs;
            }
            size_t realindent = indent + realnumifs;

            for (size_t i = 0; i < realindent; ++i)
                fprintf(outfp, indentation);
            fprintf(outfp, keyw[commandindex]);



            ++block;

            auto const param1 = defangOffset(*block);

            uint8_t paramstart = 1;

            switch (commandindex)
            {
                case CON_STATE:
                    printstate(param1);
                    break;
                case CON_IFACTION:
                case CON_ACTION:
                    printaction(param1);
                    break;
                case CON_MOVE:
                case CON_IFMOVE:
                    printmove(param1);
                    break;
                case CON_AI:
                case CON_IFAI:
                    printai(param1);
                    break;
                case CON_ELSE:
                    if (param1 == (block - script) + 1)
                        fprintf(outfp, " // This comment is necessary due to a bug in the original game's CON parser.");
                    // fallthrough
                case CON_LEFTBRACE:
                    if (raw)
                        printcommentu(param1);
                    break;
                default:
                    paramstart = 0;
                    break;
            }

            if (flags & CONFLAG_32BIT && sizeof(bytecode_t) != sizeof(int32_t))
            {
                int32_t const * const block32 = (int32_t const *)block;
                for (uint8_t p = paramstart; p < params; ++p)
                {
                    printi32(block32[p]);
                }
                block += sizeof(int32_t)/sizeof(bytecode_t);
            }
            else
            {
                if (flags & CONFLAG_UNSIGNED)
                {
                    for (uint8_t p = paramstart; p < params; ++p)
                    {
                        printu(block[p]);
                    }
                }
                else
                {
                    size_t const nonzero = (flags & CONFLAG_OPTIONALAFTERFIRST) ? calcnonzeroparams(block + paramstart, params) : params;

                    for (uint8_t p = paramstart; p < nonzero; ++p)
                    {
                        printi(block[p]);
                    }
                }

                block += params;
            }

            if (flags & CONFLAG_IF)
            {
                if (raw)
                    printcommentu(*block);
                ++block;
                ++numifs;
            }
            else if (commandindex == CON_ELSE)
            {
                ++numifs;
            }
            else
            {
                numifs = 0;
            }

            fprintf(outfp, newline);

            if (commandindex == CON_LEFTBRACE)
                decompileblock(block, id, CON_RIGHTBRACE, realindent + 1);
        }

        for (size_t i = 1; i < indent; ++i)
            fprintf(outfp, indentation);
        fprintf(outfp, keyw[terminator]);
        fprintf(outfp, newline);
        ++block;
    }

    FILE * outfp;

    bytecode_t offset_offset, offset_width;

    bool valid = false;

    decompiler(char const * fn, filepos_t gamestartup_offset, filepos_t script_offset_, filepos_t actorscrptr_offset_, filepos_t actortype_offset_, size_t script_count_, bytecode_t offset_offset_ = 0, bytecode_t offset_width_ = 1) :
        script_offset(script_offset_),
        actorscrptr_offset(actorscrptr_offset_),
        actortype_offset(actortype_offset_),
        script_count(script_count_),
        outfp(nullptr),
        offset_offset(offset_offset_),
        offset_width(offset_width_)
    {
        memset(gamestartup, 0, sizeof(gamestartup));
        memset(script, 0, sizeof(script));
        memset(actorscrptr, 0, sizeof(actorscrptr));
        memset(actortype, 0, sizeof(actortype));

        FILE * const fp = fopen(fn, "rb");
        if (fp == nullptr)
            return;

        if (gamestartup_offset != (filepos_t)-1)
        {
            if (gamestartup_offset < 0)
                gamestartup_offset += script_offset;
            fseek(fp, script_offset - sizeof(gamestartup), SEEK_SET);
            fread(gamestartup, sizeof(gamestartup), 1, fp);
        }

        fseek(fp, script_offset, SEEK_SET);
        fread(script, sizeof(script), 1, fp);
        if (script_count == (size_t)-1 || script_count == (size_t)-3)
        {
            bytecode_t bytescriptsize;
            memcpy(&bytescriptsize, script, sizeof(bytecode_t));
            if (script_count == (size_t)-3)
                bytescriptsize = SwapFuncs<sizeof(bytecode_t)>::Swap(bytescriptsize);
            script_count = defangOffset(bytescriptsize);
        }

        if (actorscrptr_offset_ != (filepos_t)-1)
        {
            fseek(fp, actorscrptr_offset, SEEK_SET);
            fread(actorscrptr, sizeof(actorscrptr), 1, fp);
        }

        if (actortype_offset_ != (filepos_t)-1)
        {
            fseek(fp, actortype_offset_, SEEK_SET);
            fread(actortype, sizeof(actortype), 1, fp);
        }

        fclose(fp);

        valid = true;
    }

    void Preprocess()
    {
        memset(knownused, 0, sizeof(knownused));

        fprintf(stdout, "descending call trees:\n");

        for (size_t i = 0; i < ARRAY_COUNT(actorscrptr); ++i)
        {
            actorscrptr_t const id = actorscrptr[i];
            if (id != 0)
            {
                actors[id] = i;
                fprintf(stdout, "actor bytecode id %d\n", id);

                bytecode_t const * const code = script + id;

                bytecode_t codeparams[] = { defangOffset(code[1]), defangOffset(code[2]) };

                if (codeparams[0])
                    maybeaddaction(codeparams[0]);

                if (codeparams[1])
                    maybeaddmove(codeparams[1]);

                markusedunsure(code - script, numactorparams);
                prepareblock(code + numactorparams, id, CON_ENDA);
            }
        }

        blocktypes.resize(script_count);

#if 1
        // gap filling heuristics
        size_t i = 1;
        while (i < script_count)
        {
            while (i < script_count && knownused[i])
            {
                ++i;
            }

            if (i >= script_count)
                break;

            size_t j = i;

            do
            {
                ++j;
            }
            while (j < script_count && !knownused[j]);

            if (j >= script_count)
                break;

            if (script[j-1] != CON_ENDS)
            {
                switch (j-i)
                {
                    case numactionparams:
                        maybeaddaction(i);
                        break;
                    case numactionparams*2:
                        maybeaddaction(i);
                        maybeaddaction(i+numactionparams);
                        break;
                    case nummoveparams:
                        maybeaddmove(i);
                        break;
                    case numaiparams:
                        maybeaddai(i);
                        break;
                }
            }
#if 1
            // really crappy state detection since the actions/moves seems to get lucky and unused ones only come as singletons
            else
            {
                maybeaddstate(i); // truly maybe here; should not crash if fail
                j = i; // let the parsing find CON_ENDS, try again from the start of this block
            }
#endif

            i = j;
        }
#endif

        {
            size_t const actionssize = actions.size();
            size_t const movessize = moves.size();
            size_t const aissize = ais.size();
            size_t const statessize = states.size();
            size_t const actorssize = actors.size();

            seq_actions.reserve(actionssize);
            seq_moves.reserve(movessize);
            seq_ais.reserve(aissize);
            seq_states.reserve(statessize);
            seq_actors.reserve(actorssize);

            // size_t const blockstartssize = actionssize + movessize + aissize + statessize + actorssize;
            // blockstarts.reserve(blockstartssize);
        }

        bytecode_t count;
        count = 1;
        for (auto x : actions)
        {
            seq_actions[x] = count++;
            blocktypes[x] = CON_ACTION;
        }
        count = 1;
        for (auto x : moves)
        {
            seq_moves[x] = count++;
            blocktypes[x] = CON_MOVE;
        }
        count = 1;
        for (auto x : ais)
        {
            seq_ais[x] = count++;
            blocktypes[x] = CON_AI;
        }
        count = 1;
        for (auto x : states)
        {
            seq_states[x] = count++;
            blocktypes[x] = CON_STATE;
        }
        count = 1;
        for (auto x : actors)
        {
            seq_actors[x.first] = count++;
            blocktypes[x.first] = CON_ACTOR;
        }
    }

    bool seq, raw, anonymous;

    void MakeItSo(char const * outfn, bool seq_ = true, bool raw_ = false, bool anonymous_ = false)
    {
        seq = seq_;
        raw = raw_;
        anonymous = anonymous_;

        outfp = fopen(outfn, "wb");

        if (!script[0])
        {
            fputc(0, outfp);
            fclose(outfp);
            return;
        }

        fprintf(stdout, "generating CON text files\n");

        if (raw)
        {
            std::map<bytecode_t, bytecode_t> sparse_actorscrptr;
            for (auto x : actors)
            {
                sparse_actorscrptr[x.second] = x.first;
            }

            for (auto x : sparse_actorscrptr)
            {
                fprintf(outfp, "define");
                printactor(x.second);
                fprintf(outfp, " %d", x.first);
                fprintf(outfp, newline);
            }

            fprintf(outfp, newline);
        }

        int32_t ormask = 0;
        for (size_t i = 0; i < ARRAY_COUNT(gamestartup); ++i)
            ormask |= gamestartup[i];

        if (ormask)
        {
            fprintf(outfp, keyw[CON_GAMESTARTUP]);
            for (size_t i = 0; i < ARRAY_COUNT(gamestartup); ++i)
                printi32(gamestartup[i]);
            fprintf(outfp, newline);
        }

        if (raw)
        {
            fprintf(outfp, newline);
            fprintf(outfp, "// %u", script[0]);
            fprintf(outfp, newline);
        }


        bytecode_t const * code = script + 1;
        bytecode_t const * const codeend = script + script_count;

        uint8_t lasttype = ~0;
        ptrdiff_t lastcount = 0;

        while (code < codeend)
        {
            ptrdiff_t const index = code - script;

            uint8_t type = blocktypes[index];
            if (type != lasttype || lasttype == CON_ACTOR || lasttype == CON_STATE)
                fprintf(outfp, newline);

            auto const tryactor = actors.find(index);
            if (tryactor != actors.end())
            {
                auto const picnum = tryactor->second;
                if (actortype[picnum] != 0)
                {
                    fprintf(outfp, keyw[CON_USERACTOR]);
                    printu(actortype[picnum]);
                }
                else
                    fprintf(outfp, keyw[CON_ACTOR]);

                if (raw)
                    printactor(index);
                else
                    printtilenum(picnum);

                size_t const nonzero = calcnonzeroparams(code, numactorparams);

                if (nonzero > 0)
                    printstrength(code[0]);

                if (nonzero > 1)
                    printaction(defangOffset(code[1]));

                if (nonzero > 2)
                    printmove(defangOffset(code[2]));

                if (nonzero > 3)
                    printmoveflags(code[3]);

                fprintf(outfp, newline);

                code += numactorparams;

                decompileblock(code, index, CON_ENDA);

                lastcount = code - script - index;
                complainifunused(index, lastcount);

                type = CON_ACTOR;
            }
            else if (states.count(index))
            {
                fprintf(outfp, keyw[CON_STATE]);
                printstate(index);

                fprintf(outfp, newline);

                decompileblock(code, index, CON_ENDS);

                lastcount = code - script - index;
                complainifunused(index, lastcount);

                type = CON_STATE;
            }
            else if (actions.count(index))
            {
                fprintf(outfp, keyw[CON_ACTION]);
                printaction(index);

                size_t const nonzero = calcnonzeroparams(code, numactionparams);

                for (size_t i = 0; i < nonzero; ++i)
                    printi(code[i]);

                code += numactionparams;

                fprintf(outfp, newline);

                lastcount = code - script - index;
                complainifunused(index, lastcount);

                type = CON_ACTION;
            }
            else if (moves.count(index))
            {
                fprintf(outfp, keyw[CON_MOVE]);
                printmove(index);

                size_t const nonzero = calcnonzeroparams(code, nummoveparams);

                for (size_t i = 0; i < nonzero; ++i)
                    printi(code[i]);

                code += nummoveparams;

                fprintf(outfp, newline);

                lastcount = code - script - index;
                complainifunused(index, lastcount);

                type = CON_MOVE;
            }
            else if (ais.count(index))
            {
                fprintf(outfp, keyw[CON_AI]);
                printai(index);

                size_t const nonzero = calcnonzeroparams(code, numaiparams);

                if (nonzero > 0)
                    printaction(defangOffset(code[0]));

                if (nonzero > 1)
                    printmove(defangOffset(code[1]));

                if (nonzero > 2)
                    printmoveflags(code[2]);

                code += numaiparams;

                fprintf(outfp, newline);

                lastcount = code - script - index;
                complainifunused(index, lastcount);

                type = CON_AI;
            }
            else // dumping unknown bytes to text
            {
                bytecode_t const value = *code++;
                fprintf(outfp, "// unknown[");
                if (!anonymous)
                    fprintf(outfp, "%" size_t_u, index);
                fprintf(outfp, "]: ");
                printcommand(value);
                fprintf(outfp, newline);

                type = 0;

                lastcount = code - script - index;
                complainifused(index, lastcount);
            }

            lasttype = type;
        }

        fclose(outfp);
        outfp = nullptr;
    }

    void DumpBytecodeToText(char const * textfn)
    {
        outfp = fopen(textfn, "wb");

        for (size_t z = 1; z < script_count; ++z)
        {
            printcommand(script[z]);
            fprintf(outfp, newline);
        }

        fclose(outfp);
        outfp = nullptr;
    }

    void ByteSwap()
    {
        for (auto & x : script)
            x = SwapFuncs<sizeof(x)>::Swap(x);
        for (auto & x : actorscrptr)
            x = SwapFuncs<sizeof(x)>::Swap(x);
    }

    void Dump_actorscrptr(char const * textfn)
    {
        outfp = fopen(textfn, "wb");

        fprintf(outfp, "actor\tindex\thex offset");
        fprintf(outfp, newline);
        for (size_t i = 0; i < ARRAY_COUNT(actorscrptr); ++i)
        {
            if (actorscrptr[i] != 0)
            {
                fprintf(outfp, "%" size_t_u "\t%d\t0x%" size_t_X "", i, actorscrptr[i], script_offset + actorscrptr[i]*sizeof(actorscrptr[0]));
                fprintf(outfp, newline);
            }
        }

        fclose(outfp);
        outfp = nullptr;
    }
};

int main(void)
{
#if 1
    {
        decompiler<int16_t, int16_t> TM_U("SLUS_003.55", -32, 0x905B4, 0x98524, -1, 16311);
        if (TM_U.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 1;
            TM_U.DumpBytecodeToText("SLUS_00355.txt");
            TM_U.Dump_actorscrptr("SLUS_00355.actorscrptr.txt");
            TM_U.Preprocess();
            TM_U.MakeItSo("SLUS_00355.CON");
            TM_U.MakeItSo("SLUS_00355_RAW.CON", false, true);
            TM_U.MakeItSo("SLUS_00355_RAW_SEQ.CON", true, true);
            TM_U.MakeItSo("SLUS_00355_ANON.CON", false, false, true);
        }
    }

    {
        decompiler<int16_t, int16_t> TM_E("SLES_007.03", -32, 0x905BC, 0x9852C, -1, 16311);
        if (TM_E.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 1;
            TM_E.DumpBytecodeToText("SLES_00703.txt");
            TM_E.Dump_actorscrptr("SLES_00703.actorscrptr.txt");
            TM_E.Preprocess();
            TM_E.MakeItSo("SLES_00703.CON");
            TM_E.MakeItSo("SLES_00703_RAW.CON", false, true);
            TM_E.MakeItSo("SLES_00703_RAW_SEQ.CON", true, true);
            TM_E.MakeItSo("SLES_00703_ANON.CON", false, false, true);
        }
    }

    {
        decompiler<int16_t, int16_t> TM_F("SLES_009.87", -32, 0x905B8, 0x98528, -1, 16311);
        if (TM_F.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 1;
            TM_F.DumpBytecodeToText("SLES_00987.txt");
            TM_F.Dump_actorscrptr("SLES_00987.actorscrptr.txt");
            TM_F.Preprocess();
            TM_F.MakeItSo("SLES_00987.CON");
            TM_F.MakeItSo("SLES_00987_RAW.CON", false, true);
            TM_F.MakeItSo("SLES_00987_RAW_SEQ.CON", true, true);
            TM_F.MakeItSo("SLES_00987_ANON.CON", false, false, true);
        }
    }

    {
        decompiler<int16_t, int16_t> TM_F_early("SLES_009.87a", -32, 0x905C4, 0x98534, -1, 16311);
        if (TM_F_early.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 1;
            TM_F_early.DumpBytecodeToText("SLES_00987a.txt");
            TM_F_early.Dump_actorscrptr("SLES_00987a.actorscrptr.txt");
            TM_F_early.Preprocess();
            TM_F_early.MakeItSo("SLES_00987a.CON");
            TM_F_early.MakeItSo("SLES_00987a_RAW.CON", false, true);
            TM_F_early.MakeItSo("SLES_00987a_RAW_SEQ.CON", true, true);
            TM_F_early.MakeItSo("SLES_00987a_ANON.CON", false, false, true);
        }
    }

    {
        decompiler<int16_t, int16_t> TM_F_Demo("SLED_010.27", -32, 0x901E4, 0x98154, -1, 16311);
        if (TM_F_Demo.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 1;
            TM_F_Demo.DumpBytecodeToText("SLED_01027.txt");
            TM_F_Demo.Dump_actorscrptr("SLED_01027.actorscrptr.txt");
            TM_F_Demo.Preprocess();
            TM_F_Demo.MakeItSo("SLED_01027.CON");
            TM_F_Demo.MakeItSo("SLED_01027_RAW.CON", false, true);
            TM_F_Demo.MakeItSo("SLED_01027_RAW_SEQ.CON", true, true);
            TM_F_Demo.MakeItSo("SLED_01027_ANON.CON", false, false, true);
        }
    }

    {
        decompiler<int16_t, int16_t> TM_J("SLPS_015.57", -32, 0x8F9B0, 0x97928, -1, 16315);
        if (TM_J.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 1;
            TM_J.DumpBytecodeToText("SLPS_01557.txt");
            TM_J.Dump_actorscrptr("SLPS_01557.actorscrptr.txt");
            TM_J.Preprocess();
            TM_J.MakeItSo("SLPS_01557.CON");
            TM_J.MakeItSo("SLPS_01557_RAW.CON", false, true);
            TM_J.MakeItSo("SLPS_01557_RAW_SEQ.CON", true, true);
            TM_J.MakeItSo("SLPS_01557_ANON.CON", false, false, true);
        }
    }

    {
        decompiler<int16_t, int16_t> TM_Prototype("SLUS_123.45", -32, 0x901A0, 0x989BC, -1, 17421);
        if (TM_Prototype.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 1;
            TM_Prototype.DumpBytecodeToText("SLUS_12345.txt");
            TM_Prototype.Dump_actorscrptr("SLUS_12345.actorscrptr.txt");
            TM_Prototype.Preprocess();
            TM_Prototype.MakeItSo("SLUS_12345.CON");
            TM_Prototype.MakeItSo("SLUS_12345_RAW.CON", false, true);
            TM_Prototype.MakeItSo("SLUS_12345_RAW_SEQ.CON", true, true);
            TM_Prototype.MakeItSo("SLUS_12345_ANON.CON", false, false, true);
        }
    }
#endif

#if 1
    {
        decompiler<int32_t, int32_t> DOS("DUKE3DCON.BIN", -32, 120, 81960, 106536, -1);
        if (DOS.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 0;
            DOS.DumpBytecodeToText("DOS.txt");
            DOS.Dump_actorscrptr("DOS.actorscrptr.txt");
            DOS.Preprocess();
            DOS.MakeItSo("DOS.CON");
            DOS.MakeItSo("DOS_RAW.CON", false, true);
            DOS.MakeItSo("DOS_RAW_SEQ.CON", true, true);
            DOS.MakeItSo("DOS_ANON.CON", false, false, true);
        }
    }
#endif

#if 1
    {
        decompiler<int32_t, int16_t> DN64_U("Duke Nukem 64 (U).z64", -1, 0xA4500, 0xB1784, -1, -3, 50000000, 4);
        if (DN64_U.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 0;
            DN64_U.ByteSwap();
            DN64_U.DumpBytecodeToText("DN64_U.txt");
            DN64_U.Dump_actorscrptr("DN64_U.actorscrptr.txt");
            DN64_U.Preprocess();
            DN64_U.MakeItSo("DN64_U.CON");
            DN64_U.MakeItSo("DN64_U_RAW.CON", false, true);
            DN64_U.MakeItSo("DN64_U_RAW_SEQ.CON", true, true);
            DN64_U.MakeItSo("DN64_U_ANON.CON", false, false, true);
        }
    }

    {
        decompiler<int32_t, int16_t> DN64_E("Duke Nukem 64 (E).z64", -1, 0xA4530, 0xB17B4, -1, -3, 50000000, 4);
        if (DN64_E.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 0;
            DN64_E.ByteSwap();
            DN64_E.DumpBytecodeToText("DN64_E.txt");
            DN64_E.Dump_actorscrptr("DN64_E.actorscrptr.txt");
            DN64_E.Preprocess();
            DN64_E.MakeItSo("DN64_E.CON");
            DN64_E.MakeItSo("DN64_E_RAW.CON", false, true);
            DN64_E.MakeItSo("DN64_E_RAW_SEQ.CON", true, true);
            DN64_E.MakeItSo("DN64_E_ANON.CON", false, false, true);
        }
    }

    {
        decompiler<int32_t, int16_t> DN64_F("Duke Nukem 64 (F).z64", -1, 0xA41D0, 0xB1454, -1, -3, 50000000, 4);
        if (DN64_F.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 0;
            DN64_F.ByteSwap();
            DN64_F.DumpBytecodeToText("DN64_F.txt");
            DN64_F.Dump_actorscrptr("DN64_F.actorscrptr.txt");
            DN64_F.Preprocess();
            DN64_F.MakeItSo("DN64_F.CON");
            DN64_F.MakeItSo("DN64_F_RAW.CON", false, true);
            DN64_F.MakeItSo("DN64_F_RAW_SEQ.CON", true, true);
            DN64_F.MakeItSo("DN64_F_ANON.CON", false, false, true);
        }
    }

    {
        decompiler<int32_t, int16_t> DN64_Proto("Duke Nukem 64 (Prototype).z64", -1, 0xA39A0, 0xB0C24, -1, -3, 50000000, 4);
        if (DN64_Proto.valid)
        {
            cmds[CON_LEFTBRACE].numblocklevelbytecodeparams = 0;
            DN64_Proto.ByteSwap();
            DN64_Proto.DumpBytecodeToText("DN64_Proto.txt");
            DN64_Proto.Dump_actorscrptr("DN64_Proto.actorscrptr.txt");
            DN64_Proto.Preprocess();
            DN64_Proto.MakeItSo("DN64_Proto.CON");
            DN64_Proto.MakeItSo("DN64_Proto_RAW.CON", false, true);
            DN64_Proto.MakeItSo("DN64_Proto_RAW_SEQ.CON", true, true);
            DN64_Proto.MakeItSo("DN64_Proto_ANON.CON", false, false, true);
        }
    }
#endif

    return 0;
}
